#include <bits/stdc++.h>
using namespace std;

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);

    int N, Q;
    cin >> N >> Q;
    vector<int> P(N);
    for (int i = 0; i < N; ++i) {
        cin >> P[i];
    }

    int breakpoints = 0;
    for (int i = 0; i < N - 1; ++i) {
        if (P[i+1] != P[i] + 1) {
            breakpoints++;
        }
    }

    cout << breakpoints << '\n';

    for (int q = 0; q < Q; ++q) {
        int x, y;
        cin >> x >> y;
        x--; y--;

        if (x > y) swap(x, y);
        if (x == y) { // Though problem states i != j, handle it if necessary
            cout << breakpoints << '\n';
            continue;
        }

        set<pair<int, int>> affected;
        for (int pos : {x, y}) {
            if (pos > 0) {
                affected.insert({pos - 1, pos});
            }
            if (pos < N - 1) {
                affected.insert({pos, pos + 1});
            }
        }

        // Remove old breakpoints
        for (auto &p : affected) {
            int a = p.first, b = p.second;
            if (P[a] + 1 != P[b]) {
                breakpoints--;
            }
        }

        // Swap elements
        swap(P[x], P[y]);

        // Add new breakpoints
        for (auto &p : affected) {
            int a = p.first, b = p.second;
            if (P[a] + 1 != P[b]) {
                breakpoints++;
            }
        }

        cout << breakpoints << '\n';
    }

    return 0;
}